var receiver = 'receiver.php';
var maxNumFiles = 100;
var maxFileSize = '30 MB';
var console = $('#console');
var tableHeader = '<tr><th>File</th><th>Size</th><th>Del.</th><th>Upload</th></tr>';
var fileCountOld = 0;
var fileIndex = 0;
var maxLength;
var innWidth;

var filter = 
    {
      max_file_size : maxFileSize,
      mime_types: [
        {title : "Image files", extensions : "jpg,jpeg,gif,png,bmp,tif,tiff,svg"},
        {title : "Pdf files", extensions : "pdf"},
        {title : "Office files", extensions : "doc,docx,xlsx,pptx,pub,odt"},
        {title : "Text files", extensions : "txt"},
        {title : "Media files", extensions : "wav,mp3,mp4,ogg"},
        {title : "Zip files", extensions : "zip,rar"}
      ]
    };

var uploader = new plupload.Uploader({
  browse_button: 'btnBrowse',
  url: receiver,
  max_files: maxNumFiles,
  filters : filter
});

uploader.init();

uploader.bind('FilesAdded', function(up, files) {
  var row;
  var re = /(?:\.([^.]+))?$/;
  if (up.files.length <= up.settings.max_files) {
    fileIndex = 0;
    plupload.each(files, function(file) {
      var ext = re.exec(file.name)[1];
      row = '<tr id="' + file.id + 
            '"><td class="first_col"><img id="im' + file.id + '" src="" width="auto" height="60" /><br />' + file.name.substr(0, maxLength) + 
            '</td><td>' + plupload.formatSize(file.size) + 
            '</td><td><a href="javascript:;" id="a' + file.id + '" class="delete"><img src="pics/Delete.png" class="deletePic" /></a>'+
            '</td><td><div class="progressBorder"><div class="progress"></div></div><span class="percent"></span>'+
            '</td></tr>';
      $('#filelist table').append(row);

      if (ext.toLowerCase() == "jpg" 
        || ext.toLowerCase() == "jpeg"
        || ext.toLowerCase() == "png" 
        || ext.toLowerCase() == "gif" 
        || ext.toLowerCase() == "bmp") {
        const reader = new FileReader();
        reader.addEventListener('load', () => {
            document.getElementById('im' + file.id).src = reader.result;
        });
        reader.readAsDataURL(files[fileIndex].getSource().getSource());
      } else if (ext.toLowerCase() == "mp4") {
        document.getElementById('im' + file.id).src = "pics/VideoSymbol.png";
      } else if (ext.toLowerCase() == "mp3" || ext.toLowerCase() == "wav") {
        document.getElementById('im' + file.id).src = "pics/MusicSymbol.png";
      } else if (ext.toLowerCase() == "zip") {
        document.getElementById('im' + file.id).src = "pics/ZIP-Symbol.png";
      } else if (ext.toLowerCase() == "pdf") {
        document.getElementById('im' + file.id).src = "pics/PDF-Symbol.png";
      } else if (ext.toLowerCase() == "xlsx" || ext.toLowerCase() == "xlsm") {
        document.getElementById('im' + file.id).src = "pics/Excel-Symbol.png";
      } else if (ext.toLowerCase() == "docx" || ext.toLowerCase() == "doc") {
        document.getElementById('im' + file.id).src = "pics/Word-Symbol.png";
      } else if (ext.toLowerCase() == "pub") {
        document.getElementById('im' + file.id).src = "pics/Publisher-Symbol.png";
      } else if (ext.toLowerCase() == "txt") {
        document.getElementById('im' + file.id).src = "pics/TXT-Symbol.png";
      } else {
        document.getElementById('im' + file.id).src = "pics/FileSymbol.png";
      }
      fileIndex = fileIndex + 1;

    });
    plupload.each(files, function(file) {
        $('#' + file.id + ' .progressBorder').hide();
        document.getElementById('a' + file.id).onclick = function() {
          if (up.state == plupload.STARTED && file.status == plupload.UPLOADING) {
            up.stop();
            up.removeFile(file);
            up.start();
          } else {
            up.removeFile(file);
          }
          $('#' + file.id).hide(500);
          if (up.files.length == 0) {
            $('#btnClear').prop('disabled', true);
          }
        };
    });
    fileCountOld = up.files.length;
  } else {
    var str;
    var anzahl = up.settings.max_files - fileCountOld;
    if (anzahl > 1) {
      str = "Es können höchstens noch " + anzahl + " Dateien hinzugefügt werden.<br />"
    } else 
    if (anzahl == 1) {
      str = "Es kann höchstens noch 1 Datei hinzugefügt werden.<br />"
    } else {
      str = "Es kann keine Datei mehr hinzugefügt werden.<br />"
    }
    console.append("Die Liste kann höchstens " + up.settings.max_files + " Dateien enthalten!<br />" + str);
    up.splice(fileCountOld);
  }
  $('#btnClear').prop('disabled', false);
});

uploader.bind('QueueChanged', function (up) {
  if (uploader.files.length == 0) {
    $('#btnUpload').prop('disabled', true);
  } else {
    $('#btnUpload').prop('disabled', false);
    $('#btnUpload').focus();
  }
  if (up.files.length < fileCountOld) {
    fileCountOld = up.files.length;
  }
}); 

uploader.bind('BeforeUpload', function(up, file) {
  $('#btnUpload').prop('disabled', true);
  $('#' + file.id + ' .progressBorder').show();
});

uploader.bind('UploadProgress', function(up, file) {
  $('#' + file.id + ' .percent').html(file.percent + '%');
  $('#' + file.id + ' .progress').css('width', file.percent + '%');
});

uploader.bind('FileUploaded', function(up, file, res) {
  $('#' + file.id + ' .progressBorder').hide(300);
  setTimeout(setOkHook, 400, file.id);
});

function setOkHook(id) {
  $('#' + id + ' .percent').append(" <img src='pics/Ok.png' class='picOk' />");
  $('#a' + id).hide(100);
}
 
uploader.bind('UploadComplete', function (up, file) {
  $('#btnUpload').prop('disabled', true);
  $('#kommentarinput').val("");
  $('#kommentaranzeige').css('display', 'none');
});

uploader.bind('Error', function(up, err) {
  var filesize = strFileSize(err.file.size);
  var meldung = "<span class='filename'>" + err.file.name + "</span><br />";
  switch (err.code) {
    case -600:
      if (err.file.size > 0) {
        meldung += "Datei zu groß: " + filesize + " (max. " + filter.max_file_size + ")<br />";
      } else {
        meldung += "Dateigröße ist 0 Bytes!<br />";
      }
      break;
    case -601:
      meldung += "Unerlaubte Dateiendung!<br />";
      break;
    default:
      meldung += "Error" + err.code + ": " + err.message + " (Filesize: " + filesize + ")<br />";
  }
  meldung += "<br />";
  $('#console').append(meldung);
});
 
$('#btnBrowse').click(() => {
  console.html("");
});

$('#btnUpload').click(() => {
  uploader.start();
  console.html("");
});

$('#btnClear').click(() => {
  $('#filelist table').html(tableHeader);
  uploader.splice(0, uploader.files.length);
  $('#btnClear').prop('disabled', true);
  console.html("");
  fileCountOld = 0;
  return false;
});

function strFileSize(bytes, decimalPlaces = 1, separator = ' ') {
    if (bytes) {
        const sizes = ['Bytes', 'kB', 'MB', 'GB', 'TB'];
        const i = Math.min(parseInt(Math.floor(Math.log(bytes) / Math.log(1024)).toString(), 10), sizes.length - 1);
        return `${(bytes / (1024 ** i)).toFixed(i ? decimalPlaces : 0)}${separator}${sizes[i]}`;
    }
    return '0 Bytes';
}

$(window).resize(function() {
    setMaxLength();
});

function setMaxLength() {
    innWidth = $(window).width();
    if (innWidth <= 480) {
        maxLength = 32;
    } else {
        maxLength = 70;
    }
}

setMaxLength();
$('#btnUpload').prop('disabled', true);  // for page refresh (F5)
$('#btnClear').prop('disabled', true);   //      "
$('#btnBrowse').focus();

$('#filelist table').html(tableHeader);